// SampleListView.cpp : implementation file
//

// (C) Copyright 1999 by Autodesk, Inc. 
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted, 
// provided that the above copyright notice appears in all copies and 
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting 
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to 
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//

#include "stdafx.h"
#include "resource.h"
#include "SampleListView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSampleListView

IMPLEMENT_DYNCREATE(CSampleListView, CListView)

CSampleListView::CSampleListView()
{
}

CSampleListView::~CSampleListView()
{	
}


BEGIN_MESSAGE_MAP(CSampleListView, CListView)
	//{{AFX_MSG_MAP(CSampleListView)
	ON_WM_CREATE()
	ON_NOTIFY_REFLECT(LVN_ITEMCHANGED, OnItemchanged)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSampleListView drawing

void CSampleListView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CSampleListView diagnostics

#ifdef _DEBUG
void CSampleListView::AssertValid() const
{
	CListView::AssertValid();
}

void CSampleListView::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSampleListView message handlers

/////////////////////////////////////////////////////////////////
int CSampleListView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CListView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	return 0;
}

/////////////////////////////////////////////////////////////////
BOOL CSampleListView::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName,
							 DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
	dwStyle |= LVS_REPORT | LVS_EX_TRACKSELECT | LVS_EX_CHECKBOXES |LVS_SHOWSELALWAYS;

	ListView_SetExtendedListViewStyle(m_hWnd, LVS_REPORT| LVS_EX_CHECKBOXES | LVS_EX_FULLROWSELECT);

	ListView_SetExtendedListViewStyleEx(m_hWnd, LVS_REPORT| LVS_EX_CHECKBOXES | LVS_EX_FULLROWSELECT,
		LVS_REPORT| LVS_EX_CHECKBOXES | LVS_EX_FULLROWSELECT);
	
	return CWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, pContext);
}


/////////////////////////////////////////////////////////////////
void CSampleListView::Init()
{
	CListCtrl& listCtrl = GetListCtrl();

	ListView_SetExtendedListViewStyleEx(m_hWnd, LVS_REPORT| LVS_EX_CHECKBOXES | LVS_EX_FULLROWSELECT,
		LVS_REPORT| LVS_EX_CHECKBOXES | LVS_EX_FULLROWSELECT);
	
	VERIFY (-1 != listCtrl.InsertColumn(0, "Object Data Field", LVCFMT_LEFT, 100));
	VERIFY (-1 != listCtrl.InsertColumn(1, "Value", LVCFMT_LEFT, 145));
}

/////////////////////////////////////////////////////////////////
void CSampleListView::SetColumns( LPSTR pColNames, int iColCt, int *piColWi )
{
	LPSTR	pCName = pColNames;

	CListCtrl& listCtrl = GetListCtrl();

	for ( int i = 0; i < iColCt; i++ )
	{
		listCtrl.InsertColumn( i, pCName, LVCFMT_LEFT, *piColWi, -1 );
		piColWi++;
		pCName += strlen( pCName ) + 1;
	}
}

/////////////////////////////////////////////////////////////////
void CSampleListView::AddRow(LPSTR pRowText)
{
	if ( !pRowText )
		return;

	CListCtrl& listCtrl = GetListCtrl();

	int iItem = listCtrl.GetItemCount();
	listCtrl.InsertItem( iItem, pRowText );
	LPSTR pPtr = pRowText + strlen( pRowText ) + 1;

	int i = 1;
	while ( strlen( pPtr ) > 0 )
	{
		listCtrl.SetItemText( iItem, i, pPtr );
		pPtr += strlen( pPtr ) + 1;
		i++;
	}

	SetLVCheck(iItem, FALSE);
}

/////////////////////////////////////////////////////////////////
BOOL CSampleListView::AddItem(int nItem, int nSubItem, LPCTSTR strItem)
{
	// add an item to the list control

	// insert the text for an item into the list control
	LV_ITEM lvItem;
	lvItem.mask = LVIF_TEXT;
	lvItem.iItem = nItem;
	lvItem.iSubItem = nSubItem;
	lvItem.pszText = (LPTSTR) strItem;

	CListCtrl& listCtrl = GetListCtrl();

	if(nSubItem == 0)
	{
		return listCtrl.InsertItem(&lvItem);
	}

	return listCtrl.SetItem(&lvItem);
}

/////////////////////////////////////////////////////////////////
void CSampleListView::ClearList()
{
	CListCtrl& listCtrl = GetListCtrl();
	listCtrl.DeleteAllItems();
}


/////////////////////////////////////////////////////////////////////////////
void CSampleListView::OnItemchanged(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	*pResult = 0;

	int m_iSelectedItem = pNMListView->iItem;
	
	if (pNMListView->uOldState == 0 && pNMListView->uNewState == 0)
		return;	// No change
	
	BOOL bPrevState = (BOOL)(((pNMListView->uOldState & LVIS_STATEIMAGEMASK)>>12)-1);
	
	// Old check box state
	if (bPrevState < 0)	// On startup there's no previous state 
		bPrevState = 0; // so assign as false (unchecked)
	
	// New check box state
	BOOL bChecked=(BOOL)(((pNMListView->uNewState & LVIS_STATEIMAGEMASK)>>12)-1);   
	
	if (bChecked < 0) // On non-checkbox notifications assume false
		bChecked = 0; 
	
	if (bPrevState == bChecked) // No change in check box
		return;	
	
	// Now bChecked holds the new check box state
	
		
	*pResult = 0;
}

/////////////////////////////////////////////////////////////////////////////
void CSampleListView::SetLVCheck(int ItemIndex, BOOL bCheck)
{
	ListView_SetItemState(m_hWnd, ItemIndex,
		UINT((int(bCheck) + 1) << 12), LVIS_STATEIMAGEMASK);
}

/////////////////////////////////////////////////////////////////
BOOL CSampleListView::UseToolTips()
{
	//check all the items to see if any are checked
	CListCtrl& listCtrl = GetListCtrl();

	for(int i=0; i < listCtrl.GetItemCount(); i++)
	{
		if(listCtrl.GetCheck(i))  //if just one in the list then we have tool tips
			return TRUE;
	}

	return FALSE;
}

/////////////////////////////////////////////////////////////////
BOOL CSampleListView::IsItemChecked(int iItem)
{
	CListCtrl& listCtrl = GetListCtrl();
	return listCtrl.GetCheck(iItem);
}

/////////////////////////////////////////////////////////////////
void CSampleListView::GetCheckedItems(CStringArray &strArray)
{
	//check all the items to see if any are checked
	CListCtrl& listCtrl = GetListCtrl();

	for(int i=0; i > listCtrl.GetItemCount(); i++)
	{
		if(listCtrl.GetCheck(i))
		{
			strArray.Add(listCtrl.GetItemText(i, 0));
		}
			
	}
}

